
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/roncat.zip" ),
}
local prefabs = {
	"roncatclover",
}

-- Custom starting items
local start_inv = {
	"roncatclover",
}

local function SpringCombatMod(amt)
    if GetSeasonManager() and ((IsDLCEnabled(REIGN_OF_GIANTS) and GetSeasonManager():IsSpring()) or (IsDLCEnabled(CAPY_DLC) and GetSeasonManager():IsGreenSeason())) then
        return amt * TUNING.SPRING_COMBAT_MOD
    else
        return amt
    end
end

local function onattacked(inst, data)
	-- Remove stun lock by changing the target into an insect
	-- **A bit of a hack, but I don't know a friendlier way of removing stun lock
	local alreadyinsect = data.attacker and data.attacker:HasTag("insect")
	if data.attacker and not alreadyinsect then data.attacker:AddTag("insect") end
	-- Remove tag soon
	inst:DoTaskInTime(0, function()
		if data.attacker and not alreadyinsect then data.attacker:RemoveTag("insect") end
	end)
	
	-- Sanity increase on taking damage
	if inst.components.sanity
	and data.attacker
	then
		local amount = 0
		if data.damage >= 60 then
			if not inst.components.sanity.sane then
				inst.components.talker:Say("Wha- Where am I? Was I a squirrel?")
			end
			amount = 30
		elseif data.damage >= 16 then
			amount = 5
		elseif data.damage >= 8 then
			amount = 2.5
		end
		
		if not inst.components.sanity.sane then
			amount = amount * 2
		end
		
		inst.components.sanity:DoDelta(amount)
	end
end


-- Announce when it's clover day
local function checkcloverday(inst)
	inst:DoTaskInTime(0.5, function(inst)
		local age = GetClock().numcycles
		if age%7 == 6 then
			inst.components.talker:Say("The clovers want me to find them today!")
		end
	end)
end
local function oncycleschanged(inst, data)
	checkcloverday(inst)
end
local function taketargets(inst)
	if inst:HasTag("playerghost") then return end
	local isjinxed = IsJinxed(inst)
	local isluckprotected = FindLuckProtector(inst) ~= nil
	
    local x, y, z = inst.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x, y, z, SpringCombatMod(15), {"_combat"}, { "INLIMBO", "following"})
	for k,v in pairs(ents) do
		if math.random() < 0.2
		and v.components.combat.target ~= nil
		and v.components.combat.target ~= inst
		and not IsJinxed(v.components.combat.target)
		then
			if v.components.combat.target:HasTag("companion")
			or v.components.combat.target:HasTag("player")
			then
				--print(v, "has targeted Ron instead of", v.components.combat.target)
				-- Take target if team member
				v.components.combat:SetTarget(inst)
			elseif not isluckprotected
			and isjinxed
			and not v:HasTag("shadowcreature")
			and (v:HasTag("monster") or v:HasTag("hostile") or v:HasTag("frog"))
			then
				--print(v, "has targeted Ron instead of", v.components.combat.target)
				-- Take target if not luck protected and guy is hostile
				v.components.combat:SetTarget(inst)
			end
		end
	end
end

local fn = function(inst)
	-- 
	inst:AddTag("roncatjinx")
	inst:AddTag("roncatnamer")
	inst:AddTag("roncatcloverfinder")
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "roncat.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(250) -- Buffed health, because tanky
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(100) -- Nerfed sanity, because he thinks he's a squirrel for some reason
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst.components.health:SetAbsorptionAmount(0.5) -- Takes less damage, because tanky
	end
	
	inst:ListenForEvent("attacked", onattacked)
	
    inst:ListenForEvent("daycomplete", function(wrld, data) oncycleschanged(inst,data) end, GetWorld())
	
	inst:DoTaskInTime(1, function(inst)
		checkcloverday(inst)
	end)
	
	inst.targettakertask = inst:DoPeriodicTask(3, taketargets)
	
	-- Increase lightning strike chance if jinxed
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
	
		local PlayerLightningTarget = inst.components.playerlightningtarget
		-- Protect from lightning strikes if protected by luck
		local onstrikefn_prev = PlayerLightningTarget.onstrikefn
		local onstrikefn_plus = function(inst)
			if inst.components.health ~= nil
			and not (inst.components.health:IsDead() or inst.components.health:IsInvincible())
			and HasLuckyCharm(inst)
			or FindLuckProtector(inst)
			then
				inst:PushEvent("lightningdamageavoided")
			elseif onstrikefn_prev then
				return onstrikefn_prev(inst)
			end
		end
		PlayerLightningTarget.onstrikefn = onstrikefn_plus
	
		local GetHitChance_prev = PlayerLightningTarget.GetHitChance
		function PlayerLightningTarget:GetHitChance()
			local oldchance = GetHitChance_prev(self)
			local jinxchance = 0.90
			if oldchance < jinxchance and IsJinxed(inst) then
				return jinxchance
			end
			return oldchance
		end
	end
	
	local Inventory = inst.components.inventory
	local ApplyDamage_prev = Inventory.ApplyDamage
	function Inventory:ApplyDamage(damage, ...)
		local absorbed_damage = 0
		-- Absorb damage if wearing Ron's amulet
		if inst:HasTag("roncatcalmer") then
			absorbed_damage = damage * 0.2
		end
		if inst:HasTag("roncatguardian") then
			absorbed_damage = damage * 0.4
		end
		
		local leftover_damage = damage - absorbed_damage

		return ApplyDamage_prev(self, leftover_damage, ...)
	end
	
	
	local clovertab = {str = "CLOVER", sort=8.1, icon = "clovertab.tex", icon_atlas = "images/hud/clovertab.xml"}
	inst.components.builder:AddRecipeTab(clovertab)
	
	-- Add recipes
	if IsDLCEnabled(CAPY_DLC) then
		-- SHIPWRECK ENABLED
		local roncatdoll_recipe_v = Recipe("roncatdoll", { Ingredient("beefalowool", 4), Ingredient("rabbit", 1), Ingredient("wetgoop", 4) }, clovertab, TECH.NONE, RECIPE_GAME_TYPE.VANILLA )
		roncatdoll_recipe_v.atlas = resolvefilepath("images/inventoryimages/roncatdoll.xml")
		roncatdoll_recipe_v.sortkey = 1
		
		if IsDLCEnabled(REIGN_OF_GIANTS) then
			local roncatdoll_recipe_rog = Recipe("roncatdoll", { Ingredient("beefalowool", 4), Ingredient("coontail", 1), Ingredient("wetgoop", 4) }, clovertab, TECH.NONE, RECIPE_GAME_TYPE.ROG )
			roncatdoll_recipe_rog.atlas = resolvefilepath("images/inventoryimages/roncatdoll.xml")
			roncatdoll_recipe_rog.sortkey = 1
		end
		
		local roncatdoll_recipe_sw = Recipe("roncatdoll", { Ingredient("fabric", 4), Ingredient("doydoyfeather", 1), Ingredient("wetgoop", 4) }, clovertab, TECH.NONE, RECIPE_GAME_TYPE.SHIPWRECKED )
		roncatdoll_recipe_sw.atlas = resolvefilepath("images/inventoryimages/roncatdoll.xml")
		roncatdoll_recipe_sw.sortkey = 1
		
		local roncatpottedclover_recipe = Recipe("roncatpottedclover", { Ingredient("roncatclover", 1, "images/inventoryimages/roncatclover.xml"), Ingredient("cutstone", 1) }, clovertab, TECH.SCIENCE_ONE, RECIPE_GAME_TYPE.COMMON )
		roncatpottedclover_recipe.placer = "roncatpottedclover_placer"
		roncatpottedclover_recipe.min_spacing = 0.9
		roncatpottedclover_recipe.atlas = resolvefilepath("images/inventoryimages/roncatpottedclover.xml")
		
		local roncatpottedclover_moonrock_recipe = Recipe("roncatpottedclover_moonrock", { Ingredient("roncatclover", 1, "images/inventoryimages/roncatclover.xml"), Ingredient("marble", 1) }, clovertab, TECH.SCIENCE_TWO, RECIPE_GAME_TYPE.VANILLA )
		roncatpottedclover_moonrock_recipe.placer = "roncatpottedclover_moonrock_placer"
		roncatpottedclover_moonrock_recipe.atlas = resolvefilepath("images/inventoryimages/roncatpottedclover_moonrock.xml")
		roncatpottedclover_moonrock_recipe.min_spacing = 0.9
		
		local roncatpottedclover_obsidian_recipe = Recipe("roncatpottedclover_obsidian", { Ingredient("roncatclover", 1, "images/inventoryimages/roncatclover.xml"), Ingredient("obsidian", 3) }, clovertab, TECH.SCIENCE_TWO, RECIPE_GAME_TYPE.SHIPWRECKED )
		roncatpottedclover_obsidian_recipe.placer = "roncatpottedclover_obsidian_placer"
		roncatpottedclover_obsidian_recipe.min_spacing = 0.9
		roncatpottedclover_obsidian_recipe.atlas = resolvefilepath("images/inventoryimages/roncatpottedclover_obsidian.xml")
		
		local roncathat_recipe = Recipe("roncathat", { Ingredient("silk", 4), Ingredient("roncatclover", 4, "images/inventoryimages/roncatclover.xml"), Ingredient("goldnugget", 1) }, clovertab, TECH.MAGIC_TWO, RECIPE_GAME_TYPE.COMMON )
		roncathat_recipe.atlas = resolvefilepath("images/inventoryimages/roncathat.xml")
		
		local roncatamulet_recipe = Recipe("roncatamulet", { Ingredient("goldnugget", 3), Ingredient("roncatclover", 1, "images/inventoryimages/roncatclover.xml") }, clovertab, TECH.MAGIC_TWO, RECIPE_GAME_TYPE.COMMON )
		roncatamulet_recipe.atlas = resolvefilepath("images/inventoryimages/roncatamulet.xml")
		
		local roncatamulet_guardian_recipe_v = Recipe("roncatamulet_guardian", { Ingredient("goldnugget", 3), Ingredient("roncatclover", 3, "images/inventoryimages/roncatclover.xml"), Ingredient("marble", 4)  }, clovertab, TECH.MAGIC_TWO, RECIPE_GAME_TYPE.VANILLA )
		roncatamulet_guardian_recipe_v.atlas = resolvefilepath("images/inventoryimages/roncatamulet_guardian.xml")
		
		local roncatamulet_guardian_recipe_sw = Recipe("roncatamulet_guardian", { Ingredient("goldnugget", 3), Ingredient("roncatclover", 3, "images/inventoryimages/roncatclover.xml"), Ingredient("limestone", 4)  }, clovertab, TECH.MAGIC_TWO, RECIPE_GAME_TYPE.SHIPWRECKED )
		roncatamulet_guardian_recipe_sw.atlas = resolvefilepath("images/inventoryimages/roncatamulet_guardian.xml")
		
		local roncatamulet_peace_recipe = Recipe("roncatamulet_peace", { Ingredient("goldnugget", 3), Ingredient("roncatclover", 3, "images/inventoryimages/roncatclover.xml"), Ingredient("roncatolive", 3, "images/inventoryimages/roncatolive.xml")  }, clovertab, TECH.MAGIC_TWO, RECIPE_GAME_TYPE.COMMON )
		roncatamulet_peace_recipe.atlas = resolvefilepath("images/inventoryimages/roncatamulet_peace.xml")
	else
		--	NON-SHIPWRECKED
		local roncatdoll_recipe = Recipe("roncatdoll", { Ingredient("beefalowool", 4), Ingredient("rabbit", 1), Ingredient("wetgoop", 4) }, clovertab, TECH.NONE )
		roncatdoll_recipe.atlas = resolvefilepath("images/inventoryimages/roncatdoll.xml")
		roncatdoll_recipe.sortkey = 1
		if IsDLCEnabled(REIGN_OF_GIANTS) then
			roncatdoll_recipe.ingredients = { Ingredient("beefalowool", 4), Ingredient("coontail", 1), Ingredient("wetgoop", 4) }
		end
		
		local roncatpottedclover_recipe = Recipe("roncatpottedclover", { Ingredient("roncatclover", 1, "images/inventoryimages/roncatclover.xml"), Ingredient("cutstone", 1) }, clovertab, TECH.SCIENCE_ONE )
		roncatpottedclover_recipe.placer = "roncatpottedclover_placer"
		roncatpottedclover_recipe.min_spacing = 0.9
		roncatpottedclover_recipe.atlas = resolvefilepath("images/inventoryimages/roncatpottedclover.xml")
		
		local roncatpottedclover_moonrock_recipe = Recipe("roncatpottedclover_moonrock", { Ingredient("roncatclover", 1, "images/inventoryimages/roncatclover.xml"), Ingredient("marble", 1) }, clovertab, TECH.SCIENCE_TWO )
		roncatpottedclover_moonrock_recipe.placer = "roncatpottedclover_moonrock_placer"
		roncatpottedclover_moonrock_recipe.min_spacing = 0.9
		roncatpottedclover_moonrock_recipe.atlas = resolvefilepath("images/inventoryimages/roncatpottedclover_moonrock.xml")
		
		local roncathat_recipe = Recipe("roncathat", { Ingredient("silk", 4), Ingredient("roncatclover", 4, "images/inventoryimages/roncatclover.xml"), Ingredient("goldnugget", 1) }, clovertab, TECH.MAGIC_TWO )
		roncathat_recipe.atlas = resolvefilepath("images/inventoryimages/roncathat.xml")

		local roncatamulet_recipe = Recipe("roncatamulet", { Ingredient("goldnugget", 3), Ingredient("roncatclover", 1, "images/inventoryimages/roncatclover.xml") }, clovertab, TECH.MAGIC_TWO )
		roncatamulet_recipe.atlas = resolvefilepath("images/inventoryimages/roncatamulet.xml")
		
		local roncatamulet_guardian_recipe = Recipe("roncatamulet_guardian", { Ingredient("goldnugget", 3), Ingredient("roncatclover", 3, "images/inventoryimages/roncatclover.xml"), Ingredient("marble", 4)  }, clovertab, TECH.MAGIC_TWO )
		roncatamulet_guardian_recipe.atlas = resolvefilepath("images/inventoryimages/roncatamulet_guardian.xml")
		
		local roncatamulet_peace_recipe = Recipe("roncatamulet_peace", { Ingredient("goldnugget", 3), Ingredient("roncatclover", 3, "images/inventoryimages/roncatclover.xml"), Ingredient("roncatolive", 3, "images/inventoryimages/roncatolive.xml")  }, clovertab, TECH.MAGIC_TWO )
		roncatamulet_peace_recipe.atlas = resolvefilepath("images/inventoryimages/roncatamulet_peace.xml")
	end
	
end

return MakePlayerCharacter("roncat", prefabs, assets, fn, start_inv)
